<?php
include 'db.php';
include 'koneksi.php';
include 'session_check.php'; // Cek session login

if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $koneksi->query("DELETE FROM dosen WHERE id='$id'");
    header("Location: dosen.php");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kelola Dosen</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="flex">
    <!-- Sidebar -->
    <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
        <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
        <nav class="space-y-1">
            <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
            <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
            <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
            <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700 bg-blue-700">🧑‍🏫 Kelola Dosen</a>
            <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
            <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
            <hr class="my-3 border-gray-700">
            <a href="users.php" class="block py-2 px-4 rounded hover:bg-blue-700">👥 Manajemen User</a>
            <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="flex-1 p-8">
        <h2 class="text-3xl font-semibold mb-6">Data Dosen</h2>

        <a href="tambah_dosen.php" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded mb-4 inline-block">+ Tambah Dosen</a>

        <div class="overflow-x-auto">
            <table class="min-w-full bg-white shadow rounded">
                <thead class="bg-blue-800 text-white">
                    <tr>
                        <th class="py-3 px-4 text-left">No</th>
                        <th class="py-3 px-4 text-left">Nama Dosen</th>
                        <th class="py-3 px-4 text-left">NIP</th>
                        <th class="py-3 px-4 text-left">Mata Kuliah</th>
                        <th class="py-3 px-4 text-left">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $no = 1;
                $query = $koneksi->query("SELECT dosen.*, mata_kuliah.nama_mk 
                                          FROM dosen 
                                          JOIN mata_kuliah ON dosen.id_mata_kuliah = mata_kuliah.id");
                while ($data = $query->fetch_assoc()) {
                    echo "<tr class='border-b hover:bg-gray-100'>
                        <td class='py-2 px-4'>{$no}</td>
                        <td class='py-2 px-4'>{$data['nama']}</td>
                        <td class='py-2 px-4'>{$data['nip']}</td>
                        <td class='py-2 px-4'>{$data['nama_mk']}</td>
                        <td class='py-2 px-4'>
                            <a href='edit_dosen.php?id={$data['id']}' class='text-yellow-600 hover:underline'>Edit</a> | 
                            <a href='?hapus={$data['id']}' onclick=\"return confirm('Yakin hapus?')\" class='text-red-600 hover:underline'>Hapus</a>
                        </td>
                    </tr>";
                    $no++;
                }
                ?>
                </tbody>
            </table>
        </div>

        <a href="index.php" class="mt-6 inline-block bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded">← Kembali ke Dashboard</a>
    </div>
</div>

</body>
</html>
