<?php
include 'session_check.php';
include 'db.php';

$id = $_GET['id'] ?? 0;

// Ambil data user
$stmt = $koneksi->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

$message_username = '';
$message_password = '';

// Proses edit username
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_username'])) {
    $username = $_POST['username'];
    $stmt = $koneksi->prepare("UPDATE users SET username = ? WHERE id = ?");
    $stmt->bind_param("si", $username, $id);
    if ($stmt->execute()) {
        $message_username = "✅ Username berhasil diupdate.";
        $user['username'] = $username;
    } else {
        $message_username = "❌ Gagal update username.";
    }
}

// Proses edit password
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_password'])) {
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $stmt = $koneksi->prepare("UPDATE users SET password = ? WHERE id = ?");
    $stmt->bind_param("si", $password, $id);
    if ($stmt->execute()) {
        $message_password = "✅ Password berhasil diupdate.";
    } else {
        $message_password = "❌ Gagal update password.";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Edit User</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="flex">
  <!-- Sidebar -->
  <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
    <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
    <nav class="space-y-1">
      <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
      <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
      <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
      <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
      <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
      <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
      <hr class="my-3 border-gray-700">
      <a href="users.php" class="block py-2 px-4 bg-blue-700 rounded hover:bg-blue-800">👥 Manajemen User</a>
      <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
    </nav>
  </div>

  <!-- Main Content -->
  <div class="flex-1 p-8">
    <h2 class="text-3xl font-semibold mb-6">🛠️ Edit User</h2>

    <div class="max-w-lg bg-white p-6 rounded shadow space-y-8">
      <!-- Notifikasi Username -->
      <?php if ($message_username): ?>
        <div class="p-4 rounded text-sm <?= strpos($message_username, '✅') !== false ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
          <?= $message_username ?>
        </div>
      <?php endif; ?>

      <!-- Form Edit Username -->
      <form method="POST" class="space-y-4">
        <input type="hidden" name="edit_username" value="1">
        <div>
          <label class="block text-sm font-medium text-gray-700">Username</label>
          <input type="text" name="username" value="<?= htmlspecialchars($user['username']) ?>" required
                 class="w-full border px-3 py-2 rounded focus:outline-none focus:ring">
        </div>
        <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 rounded">Simpan Username</button>
      </form>

      <hr>

      <!-- Notifikasi Password -->
      <?php if ($message_password): ?>
        <div class="p-4 rounded text-sm <?= strpos($message_password, '✅') !== false ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' ?>">
          <?= $message_password ?>
        </div>
      <?php endif; ?>

      <!-- Form Edit Password -->
      <form method="POST" class="space-y-4">
        <input type="hidden" name="edit_password" value="1">
        <div>
          <label class="block text-sm font-medium text-gray-700">Password Baru</label>
          <input type="password" name="password" required
                 class="w-full border px-3 py-2 rounded focus:outline-none focus:ring">
        </div>
        <button type="submit" class="w-full bg-green-600 hover:bg-green-700 text-white py-2 rounded">Simpan Password</button>
      </form>

      <div class="text-center">
        <a href="users.php" class="text-blue-500 hover:underline">← Kembali ke daftar user</a>
      </div>
    </div>
  </div>
</div>

</body>
</html>
