<?php
include 'session_check.php';
include 'db.php';

// Hapus data
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];
    $koneksi->query("DELETE FROM mahasiswa WHERE id='$id'");
    header("Location: mahasiswa.php");
}
?>


<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Kelola Mahasiswa</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

  <div class="flex">
    <!-- Sidebar -->
    <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
      <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
      <nav class="space-y-1">
        <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
        <a href="mahasiswa.php" class="block py-2 px-4 rounded bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
        <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
        <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
        <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
        <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
        <hr class="my-3 border-gray-700">
        <a href="users.php" class="block py-2 px-4 rounded hover:bg-blue-700">👥 Manajemen User</a>
        <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
      </nav>
    </div>

    <!-- Main Content -->
    <div class="flex-1 p-8">
      <h2 class="text-3xl font-semibold mb-6">Kelola Mahasiswa</h2>

      <a href="tambah_mahasiswa.php" class="mb-4 inline-block bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded">+ Tambah Mahasiswa</a>

      <div class="overflow-x-auto mt-4">
        <table class="min-w-full bg-white border border-gray-300 rounded">
          <thead class="bg-gray-200">
            <tr>
              <th class="py-2 px-4 border">No</th>
              <th class="py-2 px-4 border">Nama</th>
              <th class="py-2 px-4 border">NIM</th>
              <th class="py-2 px-4 border">Jurusan</th>
              <th class="py-2 px-4 border">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $no = 1;
            $query = $koneksi->query("SELECT mahasiswa.*, jurusan.nama_jurusan 
                                      FROM mahasiswa 
                                      JOIN jurusan ON mahasiswa.id_jurusan = jurusan.id");
            while ($data = $query->fetch_assoc()):
            ?>
            <tr class="hover:bg-gray-50">
              <td class="py-2 px-4 border"><?= $no++ ?></td>
              <td class="py-2 px-4 border"><?= htmlspecialchars($data['nama']) ?></td>
              <td class="py-2 px-4 border"><?= htmlspecialchars($data['nim']) ?></td>
              <td class="py-2 px-4 border"><?= htmlspecialchars($data['nama_jurusan']) ?></td>
              <td class="py-2 px-4 border text-sm">
                <a href="edit_mahasiswa.php?id=<?= $data['id'] ?>" class="text-blue-600 hover:underline">Edit</a> |
                <a href="?hapus=<?= $data['id'] ?>" onclick="return confirm('Yakin hapus?')" class="text-red-600 hover:underline">Hapus</a>
              </td>
            </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

</body>
</html>
