<?php
include 'session_check.php';
include 'db.php';

$result = $koneksi->query("SELECT * FROM users");
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Manajemen User</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="flex">
  <!-- Sidebar -->
  <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
    <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
    <nav class="space-y-1">
      <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
      <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
      <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
      <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
      <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
      <a href="view_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📊 View Nilai</a>
      <hr class="my-3 border-gray-700">
      <a href="users.php" class="block py-2 px-4 bg-blue-700 rounded hover:bg-blue-800">👥 Manajemen User</a>
      <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
    </nav>
  </div>

  <!-- Main Content -->
  <div class="flex-1 p-8">
    <h2 class="text-3xl font-semibold mb-6">👥 Daftar User</h2>

    <a href="tambah_user.php" class="mb-4 inline-block bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded">
      + Tambah User
    </a>

    <div class="overflow-x-auto">
      <table class="min-w-full bg-white shadow rounded">
        <thead class="bg-blue-800 text-white">
          <tr>
            <th class="py-3 px-4 text-left">ID</th>
            <th class="py-3 px-4 text-left">Username</th>
            <th class="py-3 px-4 text-left">Aksi</th>
          </tr>
        </thead>
        <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
          <tr class="border-b hover:bg-gray-100">
            <td class="py-2 px-4"><?= $row['id'] ?></td>
            <td class="py-2 px-4"><?= htmlspecialchars($row['username']) ?></td>
            <td class="py-2 px-4">
              <a href="edit_user.php?id=<?= $row['id'] ?>" class="text-yellow-600 hover:underline">Edit</a> |
              <a href="delete_user.php?id=<?= $row['id'] ?>" class="text-red-600 hover:underline" onclick="return confirm('Yakin ingin menghapus user ini?')">Hapus</a>
            </td>
          </tr>
        <?php endwhile; ?>
        </tbody>
      </table>
    </div>

    <a href="index.php" class="mt-6 inline-block bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
      ← Kembali ke Dashboard
    </a>
  </div>
</div>

</body>
</html>
