<?php
include 'db.php';
include 'session_check.php'; // Jika diperlukan untuk keamanan login
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Daftar Nilai Mahasiswa</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">

<div class="flex">
    <!-- Sidebar -->
    <div class="w-64 bg-blue-900 min-h-screen p-4 text-white">
        <h1 class="text-2xl font-bold mb-6">Sistem Perkuliahan</h1>
        <nav class="space-y-1">
            <a href="index.php" class="block py-2 px-4 rounded hover:bg-blue-700">🏠 Dashboard</a>
            <a href="mahasiswa.php" class="block py-2 px-4 rounded hover:bg-blue-700">👨‍🎓 Kelola Mahasiswa</a>
            <a href="mata_kuliah.php" class="block py-2 px-4 rounded hover:bg-blue-700">📘 Kelola Mata Kuliah</a>
            <a href="dosen.php" class="block py-2 px-4 rounded hover:bg-blue-700">🧑‍🏫 Kelola Dosen</a>
            <a href="input_nilai.php" class="block py-2 px-4 rounded hover:bg-blue-700">📝 Input Nilai</a>
            <a href="view_nilai.php" class="block py-2 px-4 rounded bg-blue-700">📊 View Nilai</a>
            <hr class="my-3 border-gray-700">
            <a href="users.php" class="block py-2 px-4 rounded hover:bg-blue-700">👥 Manajemen User</a>
            <a href="logout.php" class="block py-2 px-4 bg-red-600 rounded hover:bg-red-700">🚪 Logout</a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="flex-1 p-8">
        <h2 class="text-3xl font-semibold mb-6">📊 Daftar Nilai Mahasiswa</h2>

        <div class="overflow-x-auto">
            <table class="min-w-full bg-white shadow rounded">
                <thead class="bg-blue-800 text-white">
                    <tr>
                        <th class="py-3 px-4 text-left">Nama Mahasiswa</th>
                        <th class="py-3 px-4 text-left">Mata Kuliah</th>
                        <th class="py-3 px-4 text-left">Nilai</th>
                        <th class="py-3 px-4 text-left">Grade</th>
                        <th class="py-3 px-4 text-left">Status</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $query = "SELECT * FROM view_nilai_mahasiswa";
                $result = $koneksi->query($query);
                while ($row = $result->fetch_assoc()) {
                    echo "<tr class='border-b hover:bg-gray-100'>
                            <td class='py-2 px-4'>{$row['nama_mahasiswa']}</td>
                            <td class='py-2 px-4'>{$row['nama_mk']}</td>
                            <td class='py-2 px-4'>{$row['nilai']}</td>
                            <td class='py-2 px-4'>{$row['grade']}</td>
                            <td class='py-2 px-4'>" . 
                                ($row['status'] == 'Lulus' ? 
                                "<span class='text-green-600 font-semibold'>{$row['status']}</span>" :
                                "<span class='text-red-600 font-semibold'>{$row['status']}</span>") . 
                            "</td>
                        </tr>";
                }
                ?>
                </tbody>
            </table>
        </div>

        <a href="index.php" class="mt-6 inline-block bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">← Kembali ke Dashboard</a>
    </div>
</div>

</body>
</html>
